<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Select Language</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script src="https://cdn.tailwindcss.com"></script>
</head>

<body class="flex flex-col items-center justify-center min-h-screen bg-gradient-to-r from-green-500 to-blue-500 px-4">
    <!-- Logo inside body and responsive -->
    <img src="<?php echo e(asset('/assets/whiteLogo.png')); ?>" alt="SLT MOBITEL Logo" class="mb-6 w-2/3 sm:w-1/2 max-w-xs" />

    <!-- Language selector card -->
    <div class="bg-white p-6 sm:p-8 rounded-lg shadow-lg w-full max-w-sm text-center">
        <h2 class="text-lg sm:text-xl font-bold mb-6">Please select your preferred language</h2>
        <form method="GET" action="<?php echo e(route('registration.form')); ?>" class="flex flex-col gap-4">
            <button type="submit" name="lang" value="en" class="btn">English</button>
            <button type="submit" name="lang" value="si" class="btn">සිංහල</button>
            <button type="submit" name="lang" value="ta" class="btn">தமிழ்</button>
        </form>
    </div>

    <style>
        .btn {
            padding: 0.75rem 1.5rem;
            border-radius: 8px;
            background-color: #0025FF;
            color: white;
            font-weight: bold;
            transition: background-color 0.3s;
        }

        .btn:hover {
            background-color: #00C800;
        }

        .from-green-500 {
            background: linear-gradient(90deg, #00C800 0%, #00C8FF 50%, #0025FF 100%) !important;
        }
    </style>
</body>

</html>
<?php /**PATH /home/european/sltmobitelactivation.com/resources/views/select-language.blade.php ENDPATH**/ ?>