<!DOCTYPE html>
<html lang="{{ $lang ?? 'en' }}">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>SLT MOBITEL Registration</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        body {
            background: linear-gradient(90deg, #00C800 0%, #00C8FF 50%, #0025FF 100%) !important;
            background-repeat: no-repeat;
            margin: 0;
            height: 100%;
        }

        .card {
            background: rgba(255, 255, 255, 0.9);
            backdrop-filter: blur(5px);
            border-radius: 15px;
            padding: 2rem;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }

        .input-field {
            border-radius: 10px;
            border: 1px solid #256EAF;
            padding: 0.75rem;
            width: 100%;
            transition: border-color 0.3s;
        }

        .input-field:focus {
            border-color: #50B748;
            outline: none;
        }

        .btn-register {
            background: linear-gradient(90deg, #00C800 0%, #00C8FF 50%, #0025FF 100%) !important;
            border-radius: 10px;
            padding: 0.75rem;
            color: white;
            width: 100%;
            transition: opacity 0.3s;
        }

        .btn-register:hover {
            opacity: 0.9;
        }

        .loader {
            border-top-color: #50B748;
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            0% {
                transform: rotate(0deg);
            }

            100% {
                transform: rotate(360deg);
            }
        }
    </style>
</head>

<body class="flex items-center justify-center min-h-screen px-4">
    <div class="card w-full max-w-md my-5">
        <!-- Loader -->
        <div id="loader" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50 hidden"
            aria-hidden="true">
            <div class="loader ease-linear rounded-full border-8 border-t-8 border-white h-16 w-16"
                aria-label="Loading"></div>
        </div>
        <form method="POST" action="{{ route('register.store') }}" class="my-2">
            @csrf
            <input type="text" hidden name="language" value="{{ $lang ?? 'en' }}">
            <img src="{{ asset('/assets/SLTMobitel_Logo.png') }}" alt="SLT MOBITEL Logo" class="mx-auto mb-4 w-1/2" />
            <div class="space-y-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700" for="name">
                        @if ($lang == 'si')
                            නම
                        @elseif($lang == 'ta')
                            பெயர்
                        @else
                            Name
                        @endif
                        <span class="text-red-500">*</span>
                    </label>
                    <input type="text" name="name" id="name" class="input-field" value="{{ old('name') }}"
                        placeholder="@if ($lang == 'si') ඔබගේ නම ඇතුලත් කරන්න @elseif($lang == 'ta') பெயரை உள்ளிடவும் @else Enter Your Name @endif">
                    @error('name')
                        <p class="text-sm text-red-500 mt-1">{{ $message }}</p>
                    @enderror
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700" for="contact">
                        @if ($lang == 'si')
                            දුරකථන අංකය
                        @elseif($lang == 'ta')
                            தொலைபேசி எண்
                        @else
                            Contact Number
                        @endif <span class="text-red-500">*</span>
                    </label>
                    <input type="tel" name="contact" id="contact" class="input-field" value="{{ old('contact') }}"
                        pattern="[0-9]{10}"
                        placeholder="@if ($lang == 'si') ඔබගේ දුරකථන අංකය ඇතුලත් කරන්න @elseif($lang == 'ta') தொலைபேசி எண்ணை உள்ளிடவும் @else Enter Your Contact Number @endif">
                    @error('contact')
                        <p class="text-sm text-red-500 mt-1">{{ $message }}</p>
                    @enderror
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700" for="gender">
                        @if ($lang == 'si')
                            ස්ත්‍රී/පුරුෂ භාවය
                        @elseif($lang == 'ta')
                            பாலினம்
                        @else
                            Gender
                        @endif
                        <span class="text-red-500">*</span>
                    </label>
                    <select name="gender" id="gender" class="input-field">
                        <option value="">
                            @if ($lang == 'si')
                                තෝරන්න
                            @elseif($lang == 'ta')
                                தேர்வு செய்யவும்
                            @else
                                Select
                            @endif
                        </option>
                        <option value="male" {{ old('gender') == 'male' ? 'selected' : '' }}>
                            @if ($lang == 'si')
                                පුරුෂ
                            @elseif($lang == 'ta')
                                ஆண்
                            @else
                                Male
                            @endif
                        </option>
                        <option value="female" {{ old('gender') == 'female' ? 'selected' : '' }}>
                            @if ($lang == 'si')
                                ස්ත්‍රී
                            @elseif($lang == 'ta')
                                பெண்
                            @else
                                Female
                            @endif
                        </option>
                    </select>
                    @error('gender')
                        <p class="text-sm text-red-500 mt-1">{{ $message }}</p>
                    @enderror
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700" for="email">
                        @if ($lang == 'si')
                            ඊ-මේල්
                        @elseif($lang == 'ta')
                            மின்னஞ்சல்
                        @else
                            Email
                        @endif
                    </label>
                    <input type="email" name="email" id="email" class="input-field"
                        placeholder="@if ($lang == 'si') ඔබගේ ඊ-මේල් ලිපිනය ඇතුලත් කරන්න @elseif($lang == 'ta') மின்னஞ்சல் முகவரியை உள்ளிடவும் @else Enter Your Email @endif"
                        value="{{ old('email') }}">
                    <p class="mt-1 text-xs text-gray-500">
                        @if ($lang == 'si')
                            ඊ-මේල් ලිපිනය විකල්ප වේ.
                        @elseif($lang == 'ta')
                            மின்னஞ்சல் முகவரி விருப்பமானது.
                        @else
                            Email address is optional.
                        @endif
                    </p>
                    @error('email')
                        <p class="text-sm text-red-500 mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700" for="name">
                        @if ($lang == 'si')
                            සහභාගී වන්නන් සංඛ්‍යාව
                        @elseif($lang == 'ta')
                            பங்கேற்பாளர்களின் எண்ணிக்கை
                        @else
                            Number Of Attendees
                        @endif
                    </label>
                    <input type="number" name="attendees" id="attendees" class="input-field"
                        value="{{ old('attendees') }}"
                        placeholder="@if ($lang == 'si') සහභාගී වන්නන් සංඛ්‍යාව ඇතුළත් කරන්න @elseif($lang == 'ta')
பங்கேற்பாளர்களின் எண்ணிக்கையை உள்ளிடவும். @else Enter Number Of Attendees @endif">
                    @error('attendees')
                        <p class="text-sm text-red-500 mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <button type="submit" class="btn-register">
                    @if ($lang == 'si')
                        ලියාපදිංචි වන්න
                    @elseif($lang == 'ta')
                        பதிவு செய்யவும்
                    @else
                        Register
                    @endif
                </button>
            </div>
        </form>
    </div>
</body>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

@if (session('success'))
    <script>
        Swal.fire({
            title: @if ($lang == 'si')
                "සාර්ථකයි!"
            @elseif ($lang == 'ta')
                "வெற்றிகரமாக பதிவு செய்யப்பட்டது!"
            @else
                "Success!"
            @endif ,
            text: @if ($lang == 'si')
                "ඔබ සාර්ථකව ලියාපදිංචි විය!"
            @elseif ($lang == 'ta')
                "நீங்கள் வெற்றிகரமாக பதிவு செய்துள்ளீர்கள்!"
            @else
                "You registered successfully!"
            @endif ,
            icon: "success"
        });
    </script>
@endif

@if ($errors->any())
    <script>
        Swal.fire({
            title: @if ($lang == 'si')
                "දෝෂයකි!"
            @elseif ($lang == 'ta')
                "பிழை!"
            @else
                "Error!"
            @endif ,
            text: @if ($lang == 'si')
                "කරුණාකර ඇතුලත් කිරිම් පරික්ෂාකර නැවත උත්සහ කරන්න."
            @elseif ($lang == 'ta')
                "தயவுசெய்து உள்ளீடுகளை சரிபார்த்து மீண்டும் முயற்சிக்கவும்."
            @else
                "Please check your inputs and try again."
            @endif ,
            icon: "error"
        });
    </script>
@endif

<script>
    const form = document.querySelector('form');
    const loader = document.getElementById('loader');
    const submitButton = document.querySelector('.btn-register');

    form.addEventListener('submit', function(e) {
        loader.classList.remove('hidden');
        submitButton.disabled = true;
        submitButton.innerText =
            @if ($lang == 'si')
                'ලියාපදිංචි වෙමින්...';
            @elseif ($lang == 'ta')
                'பதிவு செய்யப்படுகிறது...';
            @else
                'Submitting...';
            @endif
    });

    // Reset loader and button on validation error
    window.addEventListener('load', function() {
        if ({{ $errors->any() ? 'true' : 'false' }}) {
            loader.classList.add('hidden');
            submitButton.disabled = false;
            submitButton.innerText =
                @if ($lang == 'si')
                    'ලියාපදිංචි වන්න';
                @elseif ($lang == 'ta')
                    'பதிவு செய்யவும்';
                @else
                    'Register';
                @endif
        }
    });
</script>

</html>
