<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Spin the Wheel</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <style>
        body {
            margin: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            background: linear-gradient(135deg, #256EAF, #50B748);
            font-family: 'Poppins', sans-serif;
        }

        #wrapper {
            width: 90%;
            max-width: 500px;
            margin: 20px auto;
            position: relative;
            text-align: center;
            background: rgba(255, 255, 255, 0.95);
            padding: 2rem;
            border-radius: 20px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
        }

        #instructions {
            color: #333;
            font-size: 1.2rem;
            margin-bottom: 1rem;
        }

        #txt {
            color: #333;
            font-size: 1.8rem;
            font-weight: bold;
            margin-top: 1rem;
            min-height: 2.5rem;
            transition: opacity 0.5s ease-in-out;
        }

        #txt.winner {
            animation: pulse 1s infinite;
        }

        @keyframes pulse {
            0% {
                transform: scale(1);
            }

            50% {
                transform: scale(1.05);
            }

            100% {
                transform: scale(1);
            }
        }

        #wheel {
            width: 400px;
            height: 400px;
            border-radius: 50%;
            position: relative;
            overflow: hidden;
            border: 10px solid #fff;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.3);
            margin: 0 auto;
        }

        #inner-wheel {
            width: 100%;
            height: 100%;
            transition: transform 6s cubic-bezier(0.25, 0.1, 0.25, 1);
        }

        #wheel div.sec {
            position: absolute;
            display: flex;
            justify-content: center;
            width: 0;
            height: 0;
            border-style: solid;
            border-width: 200px 57.74px 0;
            border-color: transparent;
            transform-origin: 57.74px 200px;
            left: 142.26px;
            top: 0px;
        }

        #wheel div.sec:nth-child(1) {
            transform: rotate(60deg);
            border-color: #ef4444 transparent;
        }

        #wheel div.sec:nth-child(2) {
            transform: rotate(120deg);
            border-color: #10b981 transparent;
        }

        #wheel div.sec:nth-child(3) {
            transform: rotate(180deg);
            border-color: #3b82f6 transparent;
        }

        #wheel div.sec:nth-child(4) {
            transform: rotate(240deg);
            border-color: #f59e0b transparent;
        }

        #wheel div.sec:nth-child(5) {
            transform: rotate(300deg);
            border-color: #8b5cf6 transparent;
        }

        #wheel div.sec:nth-child(6) {
            transform: rotate(0deg);
            border-color: #ec4899 transparent;
        }

        #wheel div.sec:nth-child(7) {
            transform: rotate(30deg);
            border-color: #256EAF transparent;
        }

        #wheel div.sec:nth-child(8) {
            transform: rotate(90deg);
            border-color: #50B748 transparent;
        }

        #wheel div.sec:nth-child(9) {
            transform: rotate(150deg);
            border-color: #004B8E transparent;
        }

        #wheel div.sec:nth-child(10) {
            transform: rotate(210deg);
            border-color: #082132 transparent;
        }

        #wheel div.sec:nth-child(11) {
            transform: rotate(270deg);
            border-color: #256EAF transparent;
        }

        #wheel div.sec:nth-child(12) {
            transform: rotate(330deg);
            border-color: #50B748 transparent;
        }

        #wheel div.sec .fa {
            margin-top: -160px;
            color: rgba(255, 255, 255, 0.9);
            font-size: 2.5rem;
            position: relative;
            display: block;
            text-align: center;
            text-shadow: 0 1px 2px rgba(0, 0, 0, 0.5);
        }

        #wheel div.sec .try-again {
            margin-top: -160px;
            color: rgba(255, 255, 255, 0.9);
            font-size: 2.5rem;
            position: relative;
            display: block;
            text-align: center;
            text-shadow: 0 1px 2px rgba(0, 0, 0, 0.5);
        }

        #spin {
            width: 100px;
            height: 100px;
            position: absolute;
            top: 50%;
            left: 50%;
            margin: -50px 0 0 -50px;
            border-radius: 50%;
            background: #fff;
            cursor: pointer;
            user-select: none;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
            transition: transform 0.2s, box-shadow 0.2s;
        }

        #spin:hover {
            transform: scale(1.1);
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.3);
        }

        #spin:active {
            transform: scale(0.95);
            box-shadow: 0 3px 10px rgba(0, 0, 0, 0.2);
        }

        #spin:after {
            content: "SPIN";
            text-align: center;
            line-height: 100px;
            color: #333;
            font-size: 1.5rem;
            font-weight: bold;
            text-shadow: 0 1px 0 #fff;
            position: relative;
            z-index: 1000;
            display: block;
        }

        #inner-spin {
            width: 80px;
            height: 80px;
            position: absolute;
            top: 50%;
            left: 50%;
            margin: -40px 0 0 -40px;
            border-radius: 50%;
            background: linear-gradient(to bottom, #f87171, #ef4444);
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.3) inset;
        }

        #pointer {
            position: absolute;
            top: -20px;
            left: 50%;
            transform: translateX(-50%);
            width: 0;
            height: 0;
            border-left: 20px solid transparent;
            border-right: 20px solid transparent;
            border-top: 30px solid #ff4444;
            z-index: 10;
            filter: drop-shadow(0 2px 4px rgba(0, 0, 0, 0.3));
        }

        #shine {
            width: 400px;
            height: 400px;
            position: absolute;
            top: 0;
            left: 0;
            background: radial-gradient(ellipse at center, rgba(255, 255, 255, 0.5) 0%, rgba(255, 255, 255, 0) 70%);
            opacity: 0.2;
            pointer-events: none;
        }

        @media (max-width: 500px) {
            #wrapper {
                padding: 1.5rem;
            }

            #wheel {
                width: 300px;
                height: 300px;
            }

            #wheel div.sec {
                border-width: 150px 43.3px 0;
                transform-origin: 43.3px 150px;
                left: 106.7px;
            }

            #wheel div.sec .fa {
                margin-top: -120px;
                font-size: 2rem;
            }

            #wheel div.sec .try-again {
                margin-top: -120px;
                font-size: 2rem;
            }

            #spin {
                width: 80px;
                height: 80px;
                margin: -40px 0 0 -40px;
            }

            #spin:after {
                line-height: 80px;
                font-size: 1.2rem;
            }

            #inner-spin {
                width: 64px;
                height: 64px;
                margin: -32px 0 0 -32px;
            }

            #txt {
                font-size: 1.5rem;
            }

            #pointer {
                border-top-width: 25px;
                top: -15px;
            }

            #shine {
                width: 300px;
                height: 300px;
            }

            #instructions {
                font-size: 1rem;
            }
        }
    </style>
</head>

<body>
    <div id="wrapper">
        <div id="instructions">Click the SPIN button to spin the wheel and win a prize!</div>
        <div id="wheel">
            <div id="inner-wheel">
                <div class="sec"><span class="fa fa-bell-o"></span></div>
                <div class="sec"><span class="fa fa-comment-o"></span></div>
                <div class="sec"><span class="fa fa-smile-o"></span></div>
                <div class="sec"><span class="fa fa-heart-o"></span></div>
                <div class="sec"><span class="fa fa-star-o"></span></div>
                <div class="sec"><span class="fa fa-lightbulb-o"></span></div>
                <div class="sec"><span class="try-again">🔁</span></div>
                <div class="sec"><span class="try-again">🔁</span></div>
                <div class="sec"><span class="try-again">🔁</span></div>
                <div class="sec"><span class="try-again">🔁</span></div>
                <div class="sec"><span class="try-again">🔁</span></div>
                <div class="sec"><span class="try-again">🔁</span></div>
            </div>
            <div id="spin">
                <div id="inner-spin"></div>
            </div>
            <div id="pointer"></div>
            <div id="shine"></div>
        </div>
        <div id="txt"></div>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <script>
        $(document).ready(function() {
            const prizes = [{
                    icon: 'fa-frown-o',
                    name: 'Try Again'
                },
                {
                    icon: 'fa-frown-o',
                    name: 'Try Again'
                },
                {
                    icon: 'fa-frown-o',
                    name: 'Try Again'
                },
                {
                    icon: 'fa-frown-o',
                    name: 'Try Again'
                },
                {
                    icon: 'fa-frown-o',
                    name: 'Try Again'
                },
                {
                    icon: 'fa-gift',
                    name: 'Gift'
                },
                {
                    icon: 'fa-ticket',
                    name: 'Voucher'
                },
                {
                    icon: 'fa-smile-o',
                    name: 'Surprise'
                },
                {
                    icon: 'fa-gift',
                    name: 'Gift'
                },
                {
                    icon: 'fa-ticket',
                    name: 'Voucher'
                },
                {
                    icon: 'fa-smile-o',
                    name: 'Surprise'
                },
                {
                    icon: 'fa-gift',
                    name: 'Gift'
                },
                {
                    icon: 'fa-smile-o',
                    name: 'Surprise'
                },
            ];

            const segmentAngle = 360 / prizes.length; // ~27.69 degrees
            let clicks = 0;
            let isSpinning = false;

            $('#spin').click(function() {
                if (isSpinning) return;
                isSpinning = true;
                $('#spin').prop('disabled', true);
                $('#txt').text('');

                clicks++;
                const extraDegree = Math.floor(Math.random() * 360);
                const totalDegree = (clicks * 360 * 10) + extraDegree;

                $('#inner-wheel').css({
                    'transform': `rotate(${totalDegree}deg)`
                });

                setTimeout(() => {
                    const normalizedDegree = totalDegree % 360;
                    const selectedIndex = Math.floor(((360 - normalizedDegree + (segmentAngle /
                        2)) % 360) / segmentAngle);

                    const prize = prizes[selectedIndex];
                    $('#txt').text(`You won: ${prize.name}`);

                    isSpinning = false;
                    $('#spin').prop('disabled', false);
                }, 6000);
            });
        });
    </script>
</body>

</html>
