<?php

namespace App\Http\Controllers;

use App\Models\Register;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class RegisterController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
    }

    public function showForm(Request $request)
    {
        $lang = $request->get('lang', 'en');
        return view('welcome', compact('lang'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $language = $request->language;
        // Define custom validation messages
        $messages = [
            'en' => [
                'name.required' => 'The name field is required.',
                'name.string' => 'The name must be a string.',
                'name.max' => 'The name may not be greater than 255 characters.',
                'contact.required' => 'The contact number field is required.',
                'contact.regex' => 'The contact number must be a valid 10-digit number.',
                'gender.required' => 'The gender field is required.',
                'gender.in' => 'The gender must be either male or female.',
                'email.email' => 'The email must be a valid email address.',
                'email.max' => 'The email may not be greater than 255 characters.',
            ],
            'si' => [
                'name.required' => 'නම අත්‍යවශ්‍යයි.',
                'name.string' => 'නම අකුරු විය යුතුය.',
                'name.max' => 'නම අක්ෂර 255 ට වඩා වැඩි විය නොහැක.',
                'contact.required' => 'දුරකථන අංකය අත්‍යවශ්‍යයි.',
                'contact.regex' => 'දුරකථන අංකය වලංගු ඉලක්කම් 10කින් සමන්විත විය යුතුය.',
                'gender.required' => 'ස්ත්‍රී/පුරුෂ භාවය අත්‍යවශ්‍යයි.',
                'gender.in' => 'ස්ත්‍රී/පුරුෂ භාවය පුරුෂ හෝ ස්ත්‍රී විය යුතුය.',
                'email.email' => 'ඊ-මේල් ලිපිනය වලංගු එකක් විය යුතුය.',
                'email.max' => 'ඊ-මේල් ලිපිනය අක්ෂර 255 ට වඩා වැඩි විය නොහැක.',
            ],
            'ta' => [
                'name.required' => 'பெயர் கட்டாயமாக தேவை.',
                'name.string' => 'பெயர் எழுத்துக்களாக இருக்க வேண்டும்.',
                'name.max' => 'பெயர் 255 எழுத்துக்களுக்கு மேல் இருக்கக்கூடாது.',
                'contact.required' => 'தொலைபேசி எண் கட்டாயமாக தேவை.',
                'contact.regex' => 'தொலைபேசி எண் 10 இலக்கங்களைக் கொண்டிருக்க வேண்டும்.',
                'gender.required' => 'பாலினம் கட்டாயமாக தேவை.',
                'gender.in' => 'பாலினம் ஆண் அல்லது பெண்ணாக இருக்க வேண்டும்.',
                'email.email' => 'மின்னஞ்சல் முகவரி செல்லுபடியாக இருக்க வேண்டும்.',
                'email.max' => 'மின்னஞ்சல் முகவரி 255 எழுத்துக்களுக்கு மேல் இருக்கக்கூடாது.',
            ],
        ];
        $validator = Validator::make($request->all(), [
            'name' => 'required|string|max:255',
            'contact' => 'required|regex:/^[0-9]{10}$/',
            'gender' => 'required|in:male,female',
            'email' => 'nullable|email|max:255',
            'language' => 'nullable|string|max:255',
            'attendees' => 'nullable|integer',
        ], $messages[$language]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        Register::create($validator->validated());

        return redirect()->back()->with('success', 'Registration successful!');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
